/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.constraints;

import java.util.Arrays;
import org.chocosolver.solver.constraints.Constraint;
import org.restopt.RestoptProblem;
import org.restopt.choco.PropSmallestEnclosingCircleSpatialGraph;
import org.restopt.constraints.AbstractRestoptConstraint;
import org.restopt.exception.RestoptException;

public class CompactnessConstraint
extends AbstractRestoptConstraint {
    protected double minDiameter;
    protected double maxDiameter;

    public CompactnessConstraint(RestoptProblem restoptProblem, double maxDiameter) {
        this(restoptProblem, 0.0, maxDiameter);
    }

    public CompactnessConstraint(RestoptProblem restoptProblem, double minDiameter, double maxDiameter) {
        super(restoptProblem);
        this.minDiameter = minDiameter;
        this.maxDiameter = maxDiameter;
    }

    @Override
    public void post() {
        double[][] coords = new double[this.getGrid().getNbCells()][];
        int[] pus = this.problem.getAvailablePlanningUnits();
        for (int i = 0; i < this.problem.getAvailablePlanningUnits().length; ++i) {
            try {
                coords[pus[i]] = this.getGrid().getCartesianCoordinates(pus[i]);
                continue;
            }
            catch (RestoptException e) {
                e.printStackTrace();
            }
        }
        double xMax = Arrays.stream(this.getGrid().getCartesianCoordinates()).mapToDouble(c -> c[0]).max().getAsDouble();
        double yMax = Arrays.stream(this.getGrid().getCartesianCoordinates()).mapToDouble(c -> c[1]).max().getAsDouble();
        PropSmallestEnclosingCircleSpatialGraph propCompact = new PropSmallestEnclosingCircleSpatialGraph(this.getRestoreGraphVar(), coords, this.getModel().realVar("radius", 0.5 * this.minDiameter, 0.5 * this.maxDiameter, 1.0E-5), this.getModel().realVar("centerX", -xMax, xMax, 1.0E-5), this.getModel().realVar("centerY", -yMax, yMax, 1.0E-5));
        Constraint cons = new Constraint("maxDiam", propCompact);
        this.getModel().post(cons);
    }
}

