% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authentication.R
\name{auth}
\alias{api_oauth1}
\alias{api_oauth2}
\alias{api_simple_auth}
\alias{auth}
\title{Authentication configuration/setup}
\usage{
api_simple_auth(.data, user, pwd, type = "basic")

api_oauth2(.data, token = NULL, app_name = NULL, key = NULL,
  secret = NULL, base_url = NULL, authorize = NULL, access = NULL)

api_oauth1(.data, token = NULL, app_name = NULL, key = NULL,
  secret = NULL, base_url = NULL, request = NULL, authorize = NULL,
  access = NULL)
}
\arguments{
\item{.data}{Result of a call to \code{api}}

\item{user}{user name}

\item{pwd}{password}

\item{type}{type of HTTP authentication. Should be one of the following types
supported by Curl: basic, digest, digest_ie, gssnegotiate, ntlm, ntlm_vn, any.
Default: "basic" (the most common type)}

\item{token}{An OAuth token}

\item{app_name}{An OAuth application name}

\item{key}{An OAuth key}

\item{secret}{An OAuth secret key}

\item{base_url}{option url to use as base for request, authorize and access urls.}

\item{authorize}{url to send client to for authorisation}

\item{access}{url used to exchange unauthenticated for authenticated token.}

\item{request}{url used to request initial (unauthenticated) token. If using
OAuth2.0, leave as NULL.}
}
\description{
Authentication configuration/setup
}
\examples{
\dontrun{
# simple authentication (user/password)
api('https://httpbin.org/basic-auth/user/passwd') \%>\%
 api_simple_auth(user = "user", pwd = "passwd")
## different auth type
# api('https://httpbin.org/basic-auth/user/passwd') \%>\%
#  api_simple_auth(user = "user", pwd = "passwd", type = "gssnegotiate")

# OAuth setup
## using a token
### fill in your own token
# api('https://api.github.com/') \%>\%
#   api_oauth2(token = "<token>")

# OAuth2
## using a app name, key, and secret combination
### uses a OAuth app set up by Hadley Wickham, which you'll auth against
# api('https://api.github.com/') \%>\%
#   api_oauth2(app_name = "github", key = "56b637a5baffac62cad9",
#       secret = "8e107541ae1791259e9987d544ca568633da2ebf",
#       base_url = "https://github.com/login/oauth",
#       authorize = "authorize", access = "access_token")

# OAuth1
# api('https://api.twitter.com/1.1/statuses/home_timeline.json') \%>\%
#  api_oauth1(app_name = "twitter", key = "TYrWFPkFAkn4G5BbkWINYw",
#      secret = "qjOkmKYU9kWfUFWmekJuu5tztE9aEfLbt26WlhZL8",
#      base_url = "https://api.twitter.com/oauth/",
#      request = "request_token", authorize = "authenticate", access = "access_token")

# Request some data with oauth2 via Github
## put in your username and password
# api('https://api.github.com/') \%>\%
#  api_simple_auth(user = "<foo>", pwd = "<bar>")
}
}
\seealso{
Other dsl: \code{\link{api_body}},
  \code{\link{api_config}},
  \code{\link{api_error_handler}}, \code{\link{api_query}},
  \code{\link{api}}
}

