% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{metaanalyse.PHat}
\alias{metaanalyse.PHat}
\title{metaanalyse.PHat}
\usage{
metaanalyse.PHat(
  PHat,
  PHatvar,
  DFUnknown,
  df,
  alternative = "two.sided",
  alpha = 0.05
)
}
\arguments{
\item{PHat}{The estimates of PHat obtained from a group of experiments to be meta-analysed}

\item{PHatvar}{The estimate of the variance of each PHat estimate}

\item{DFUnknown}{If DFUnknown=FALSE the degrees of freedom for each experiment is known, and the df parameter must be a vector specifying the effect size of each experiment, otherwise the df parameter is ignored.}

\item{df}{If DFUnknown is TRUE, this parameter is a vector of numerical values specifying the degrees of freedom for each experiment, and the confidence intervals, pvalues and significance test use the t-distribution probability values. If the parameter DFUNknown is FALSE, the confidence intervals, pvalues and significance test use the normal distribution probability values.}

\item{alternative}{Specifies the type of significance test and can take the values "two.sided" (default), "less" or "greater".}

\item{alpha}{The significance level (default 0.05) used to control the significance tests and calculation of confidence limits.}
}
\value{
Estimate. The simple average of the PHat values recommended by Kromrey as the best estimator for meta-analysis.

UpperCI The upper 100*(1-alpha/2)% confidence interval of the average PHat based on the t-distribution probability values if DFUnknown is FALSE, or normal probability values if DFUnknown is TRUE.

LowerCI The lower 100*(1-alpha/2)% confidence interval of the average PHat based on the t-distribution probability values ifDFUnknown is FALSE, or normal probability values if DFUnknown is TRUE.

Variance The variance of the Estimate output

tvalue The value of the t-statistic

df Either NA if the parameter DFUnknown is TRUE, or sum of the degrees of freedom for each experiment.

AltHyp Defines the alternative hypothesis used for significance testing and depends on the value of the input parameter alternative. It takes the values "Not=0.5", ">0.5", or "<0.5".

NullHyp Defines the null hypothesis and depends on the value of the input parameter alternative. It takes the values "~0.5", "<0.5", or ">0.5".

pvalue The p-value of the t-test if the parameter DFUnknown is FALSE, otherwise the normal probability value.

RejectNullHyp "Yes" or "No" depending on whether or not the null hypothesis should be rejected at the alpha/2 level for two-sided tests and alpha level for one-sided tests

The I-squared estimate of the extent of heterogeneity

The Q homogeneity statistic

ProbQHomogeneous. The probability that the set of Phat values come from a set of homogeneous experiments.
}
\description{
This function performs a meta-analysis of experiments using PHat as an effect size. It returns the 100*(1-alpha/2)% confidence interval limits, the value of the t-test, the probability asssociated with the null hypothesis and the significance of the test. The confidence interval limits, the pvalue and the significance of the statistical test vary according to the value of the alternative parameter and whether or not degrees of freedom are specifed. It also reurns the Q and I.squared statistics to assess the heterogeneity among the experiments.
}
\examples{
PHat=c(0.92,0.6,0.48,0.72,0.88)
PHatvar=c(0.01,0.04,0.05,0.04,0.01)
PHatdf=c(6.63,6.63,5.08,5.61,8)
PHatInvalid=c(0.92,0.6,0.48,0.72)
as.data.frame(metaanalyse.PHat(PHat=PHat,PHatvar=PHatvar,DFUnknown=FALSE,df=PHatdf,
 alternative="greater",alpha=0.05))
#  Estimate   UpperCI   LowerCI Variance   tvalue    df AltHyp NullHyp      pvalue RejectNullHyp..
#  1     0.72 0.8777899 0.5622101    0.006 2.840188 31.95   >0.5   <=0.5 0.003890609         Yes..
as.data.frame(metaanalyse.PHat(PHat=PHat,PHatvar=PHatvar,DFUnknown=TRUE,df=PHatdf,
  alternative="greater",alpha=0.05))
#  Estimate   UpperCI   LowerCI Variance   tvalue df AltHyp NullHyp      pvalue RejectNullHyp..
# 1     0.72 0.8718182 0.5681818    0.006 2.840188 NA   >0.5   <=0.5 0.002254349           Yes..
as.data.frame(metaanalyse.PHat(PHat=PHat,PHatvar=PHatvar,DFUnknown=FALSE,df=PHatdf,
 alternative="two.sided",alpha=0.05))
#  Estimate   UpperCI   LowerCI Variance   tvalue    df  AltHyp NullHyp      pvalue RejectNullH..
#1     0.72 0.8777899 0.5622101    0.006 2.840188 31.95 Not=0.5    ~0.5 0.007781218         Yes..
as.data.frame(metaanalyse.PHat(PHat=PHat,PHatvar=PHatvar,DFUnknown=TRUE,df=PHatInvalid,
 alpha=0.05))
# Estimate   UpperCI   LowerCI Variance   tvalue df  AltHyp NullHyp      pvalue RejectNullHyp I..
#1     0.72 0.8718182 0.5681818    0.006 2.840188 NA Not=0.5    ~0.5 0.004508698         Yes 82..
}
\author{
Barbara Kitchenham and Lech Madeyski
}
