% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lblCode.R
\name{replace_plot_labels}
\alias{replace_plot_labels}
\title{Replace variable names with labels in ggplot}
\usage{
replace_plot_labels(plot)
}
\arguments{
\item{plot}{output from a call to ggplot2}
}
\description{
If the data stored in a ggplot object has variable labels then this will
replace the variable names with the variable labels. If no labels are set
then the variable names will be tidied and a nicer version used.
}
\examples{
\dontrun{
data("pembrolizumab")
p <- ggplot(pembrolizumab,aes(x=change_ctdna_group,y=baseline_ctdna)) +
geom_boxplot()
replace_plot_labels(p)
pembrolizumab <- set_var_labels(pembrolizumab,
change_ctdna_group="Change in ctDNA group")
p <- ggplot(pembrolizumab,aes(x=change_ctdna_group,y=baseline_ctdna)) +
geom_boxplot()
replace_plot_labels(p)
# Can also be used with a pipe, but expression needs to be wrapped in a brace
(ggplot(pembrolizumab,aes(x=change_ctdna_group,y=baseline_ctdna)) +
geom_boxplot()) |> replace_plot_labels()
}
}
\seealso{
\code{\link[=set_var_labels]{set_var_labels()}} for setting individual variable labels,
\code{\link[=set_labels]{set_labels()}} for setting variable labels using a data frame,
\code{\link[=extract_labels]{extract_labels()}} for creating a data frame of all variable labels,
\code{\link[=clear_labels]{clear_labels()}} for removing variable labels
}
