% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_lazydo}
\alias{repo_lazydo}
\title{Run expression with cache.}
\usage{
repo_lazydo(expr, force = F, env = parent.frame())
}
\arguments{
\item{expr}{An object of class expression (the code to run).}

\item{force}{If TRUE, execute expr anyway}

\item{env}{Environment for expr, defaults to parent.}
}
\value{
Results of the expression (either loaded or computed on the
    fly).
}
\description{
lazydo searches the repo for previous execution of an
expression. If a previous execution is found, the result is loaded
and returned. Otherwise, the expression is executed and the result
stashed.
}
\details{
The expression results are stashed as usual. The name of
the resource is obtained by digesting the expression, so it will
look like an MD5 string in the repo. Note that the expression, and
not its result, will uniquely identify the item in the repo.

The new item is automatically tagged with "stash", "hide" and
"lazydo".
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)


## First run
system.time(rp$lazydo(
    {
        Sys.sleep(1/10)
        x <- 10
    }
))

## lazydo is building resource from code.
## Cached item name is: f3c27f11f99dce20919976701d921c62
##   user  system elapsed 
##  0.004   0.000   0.108 

## Second run
system.time(rp$lazydo(
    {
        Sys.sleep(1/10)
        x <- 10
    }
))

## lazydo found precomputed resource.
##   user  system elapsed 
##  0.001   0.000   0.001 


## The item's name in the repo can be obtained as the name of the
## last item added:

l <- length(rp$entries())
resname <- rp$entries()[[l]]$name
cat(rp$entries()[[l]]$description)
## {
##    Sys.sleep(1/10)
##    x <- 10
## }
rp$rm(resname) ## single cached item cleared

## wiping temporary repo
unlink(rp_path, TRUE)
}
\seealso{
repo_stash, repo_put
}
