% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_model.R
\name{boot_model}
\alias{boot_model}
\title{Bootstrap optimism correction for models}
\usage{
boot_model(
  formula,
  data,
  B = 200,
  fit_function = "lm",
  metric = if (length(unique(data[, as.character(formula)[2]])) == 2) "AUC" else "RMSE",
  predict.control = list(NULL),
  ...
)
}
\arguments{
\item{formula}{An object of class "formula" describing the model to be validated}

\item{data}{A data frame containing the variables specified in formula argument}

\item{B}{Number of bootstrap samples}

\item{fit_function}{Name of the model fitting function}

\item{metric}{Performance metric to estimate: RMSE, MSE, MAE  or AUC}

\item{predict.control}{Named list of arguments to pass to the predict function of the model}

\item{...}{Further arguments passed to the model fitting function}
}
\value{
Optimism correction values for the selected performance metric
}
\description{
Returns optimism correction for absolute fit values
}
\examples{
boot_model(Petal.Length ~ Sepal.Width + Species, data=iris)
}
