% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset}
\alias{subset}
\alias{subset,EotStack-method}
\alias{[[,EotStack,ANY,ANY-method}
\title{Subset modes in EotStacks}
\usage{
\S4method{subset}{EotStack}(x, subset, drop = FALSE, ...)

\S4method{[[}{EotStack,ANY,ANY}(x, i)
}
\arguments{
\item{x}{EotStack to be subset}

\item{subset}{integer or character. The modes to ectract (either by
integer or by their names)}

\item{drop}{if \code{TRUE} a single mode will be returned as an EotMode}

\item{...}{currently not used}

\item{i}{number of EotMode to be subset}
}
\value{
an Eot* object
}
\description{
Extract a set of modes from an EotStack
}
\examples{
data(vdendool)

nh_modes <- eot(x = vdendool, y = NULL, n = 3, 
                standardised = FALSE, 
                verbose = TRUE)
                
subs <- subset(nh_modes, 2:3) # is the same as
subs <- nh_modes[[2:3]]

## effect of 'drop=FALSE' when selecting a single layer
subs <- subset(nh_modes, 2)
class(subs)
subs <- subset(nh_modes, 2, drop = TRUE)
class(subs)

}
