% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-description.R
\docType{data}
\name{USCaucs}
\alias{USCaucs}
\title{CODIS STR Loci allele frequency data}
\format{
This data set is a list which has two sub-lists. The lists are named
loci and freqs. loci is a vector of the 13 CODIS STR locus names. freqs is a
list of 13 vectors, each vector contains the allele frequencies published
for US Caucasians in Budowle and Moretti (1999).  The raw data is available
from
\url{https://www.fbi.gov/about-us/lab/forensic-science-communications/fsc/july1999/dnaloci.txt}
}
\description{
This data structure
}
\examples{

data(USCaucs)
names(USCaucs)
USCaucs$loci
names(USCaucs$freqs)
USCaucs$freqs[[1]]
names(USCaucs$freqs[[1]])
USCaucs$freqs[[1]][1]
}
\references{
Budowle, B. and Moretti, T.R. (1999), \emph{Genotype Profiles
for Six Population Groups at the 13 CODIS Short Tandem Repeat Core Loci and
Other PCR Based Loci}, Forensic Science Communications 1(2).
}
\seealso{
fbiCaucs
}
\author{
James M. Curran
}
\keyword{datasets}
