% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_utils.R
\name{detect_transmutation}
\alias{detect_transmutation}
\title{Detect transmutation in formulas, such as factor(), and raise an error}
\usage{
detect_transmutation(formula, call = parent.frame())
}
\arguments{
\item{formula}{Model formula}

\item{call}{Environment in which to raise the error, defaulting to the
calling environment. As this function is recursive, this reduces the
complexity of backtraces.}
}
\value{
No value. Raises an error if transmutation is present.
}
\description{
We rely on predictors to occur in models with only one type (such as numeric
or factor), but the use of factor() would make it possible for a predictor to
appear both as a factor or as numeric. The use of factor() also makes it
harder to correctly detect the types of predictors, since the methods for
obtaining model predictors provide them before they are converted to factor,
not after. So we reject formulas that transmute types inside the formula,
such as with factor().
}
\details{
Presently only factor() calls are rejected, but if other transmutations (such
as conversions to logical or numeric) prove to be problems, they can be
rejected as well.
}
\keyword{internal}
