% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{Replacer}
\alias{Replacer}
\title{Replacer Class for Regex Operations}
\description{
The \code{Replacer} class encapsulates regex operations using named groups.
It allows matching and replacing based on named groups in a regex pattern.
}
\details{
This class provides methods to match and replace parts of a string based on
named groups in regular expressions.
}
\examples{
# Create a new Replacer object
r <- Replacer$new(pattern = ".*?_(?P<date>\\\\d{8}-\\\\d{6})(?P<ext>\\\\..+$)")

# Match a group within a string
r$match("file_20230905-123456.txt", "date")

# Replace the value of a matched group
r$replace("file_20230905-123456.txt", "date", "20240905-123456")

## ------------------------------------------------
## Method `Replacer$new`
## ------------------------------------------------

r <- Replacer$new(pattern=".*?_(?P<date>\\\\d{8}-\\\\d{6}( \\\\(1\\\\))*)(?P<ext>\\\\..+$)")

## ------------------------------------------------
## Method `Replacer$match`
## ------------------------------------------------

r <- Replacer$new(pattern=".*?_(?P<date>\\\\d{8}-\\\\d{6})(?P<ext>\\\\..+$)")
r$match("file_20230905-123456.txt", "date")

## ------------------------------------------------
## Method `Replacer$replace`
## ------------------------------------------------

r <- Replacer$new(pattern=".*?_(?P<date>\\\\d{8}-\\\\d{6})(?P<ext>\\\\..+$)")
r$replace("file_20230905-123456.txt", "date", "20240905-123456")
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{re}}{A compiled regular expression pattern.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Replacer-new}{\code{Replacer$new()}}
\item \href{#method-Replacer-match}{\code{Replacer$match()}}
\item \href{#method-Replacer-replace}{\code{Replacer$replace()}}
\item \href{#method-Replacer-clone}{\code{Replacer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Replacer-new"></a>}}
\if{latex}{\out{\hypertarget{method-Replacer-new}{}}}
\subsection{Method \code{new()}}{
Create a new Replacer object with a regex pattern.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Replacer$new(
  pattern = ".*?_(?P<date>\\\\d{8}-\\\\d{6}( \\\\(1\\\\))*)(?P<ext>\\\\..+$)"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{A character string with a regex pattern that includes named groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Replacer} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{r <- Replacer$new(pattern=".*?_(?P<date>\\\\d{8}-\\\\d{6}( \\\\(1\\\\))*)(?P<ext>\\\\..+$)")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Replacer-match"></a>}}
\if{latex}{\out{\hypertarget{method-Replacer-match}{}}}
\subsection{Method \code{match()}}{
Match a string and extract a group by its name.

This method matches the string using the regex pattern and extracts the value
of the group specified by \code{group_name}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Replacer$match(s, group_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{A character string to match against the regex pattern.}

\item{\code{group_name}}{The name of the group to extract from the match.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The matched value of the group or \code{NULL} if not found.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{r <- Replacer$new(pattern=".*?_(?P<date>\\\\d{8}-\\\\d{6})(?P<ext>\\\\..+$)")
r$match("file_20230905-123456.txt", "date")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Replacer-replace"></a>}}
\if{latex}{\out{\hypertarget{method-Replacer-replace}{}}}
\subsection{Method \code{replace()}}{
Replace the value of a matched group with a replacement string.

This method replaces the value of the matched group specified by \code{group_name}
with the \code{replacement} string in the input string \code{s}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Replacer$replace(s, group_name, replacement)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{A character string to perform the replacement on.}

\item{\code{group_name}}{The name of the group to be replaced.}

\item{\code{replacement}}{The replacement string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A modified string with the group replaced by the replacement.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{r <- Replacer$new(pattern=".*?_(?P<date>\\\\d{8}-\\\\d{6})(?P<ext>\\\\..+$)")
r$replace("file_20230905-123456.txt", "date", "20240905-123456")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Replacer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Replacer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Replacer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
