% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivRegr.R
\name{bivRegr}
\alias{bivRegr}
\title{Bivariate regression model}
\usage{
bivRegr(f = f, data = data, ace.eps = 0.01, ace.itmax = 25)
}
\arguments{
\item{f}{A list of five formulas defining the covariates effects
in both responses means, variances, and in their correlation. The formulas
follow the same structure as mgcv::gam() (see example below).}

\item{data}{A data frame containing the reponses, and predictor variables values.}

\item{ace.eps}{A number defining the error rate in the ACE algorithm.}

\item{ace.itmax}{A number defining the maximum number of ACE algorithm iterations.}
}
\value{
This function returns the covariates effect on the means,
variances, and correlation of a bivariate response variable.
}
\description{
This function estimates the covariates effects on the means vector,
and variance covariance matrix from a bivariate variable. Non linear effects
might be estimated for continuous covariates using penalized spline smoothers.
}
\examples{
# Bivariate reference region for fasting plasma glucose (fpg)
# and glycated hemoglobin (hba1c) levels depending on age

dm_no <- subset(aegis, aegis$dm == "no") # select healthy patients
# 1.1) Define predictors
mu1 <- fpg ~ s(age)
mu2 <- hba1c ~ s(age)
var1 <- ~ s(age)
var2 <- ~ s(age)
rho <- ~ s(age)
f <- list(mu1, mu2, var1, var2, rho)

fit <- bivRegr(f, data = dm_no)

# 1.2) Depict the estimated covariates effects
plot(fit, eq = 1)
plot(fit, eq = 2)
plot(fit, eq = 3)
plot(fit, eq = 4)
plot(fit, eq = 5)
# 1.2.1) Depict the estimated covariates effects with CI (Not Run)
\donttest{
s0 <- summary_boot(fit, B = 100) # no parallelization
# s1 = summary_boot(fit,B=100,parallel=TRUE) #parallelization
plot(s0, eq = 1)
}

# 1.3) Obtain the reference region in the standarized residuals
region <- bivRegion(fit, tau = 0.95, shape = 2)
plot(region)

# 1.4) Identify those patients located outside the reference region
summary(region)

# 1.5) Depict the conditional reference region for two ages
plot(region,
  cond = TRUE, newdata = data.frame(age = c(20, 50)), col = "grey", pch = "*",
  reg.lwd = 2, reg.lty = 2
)

}
