% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilsRIVerification.R
\name{getEquivalenceLimits}
\alias{getEquivalenceLimits}
\title{Calculate equivalence limits}
\usage{
getEquivalenceLimits(
  RI,
  RIperc = c(0.025, 0.975),
  CIprop = 0.9,
  pCVA.exp = 0.5,
  with.bias = FALSE,
  n = NULL
)
}
\arguments{
\item{RI}{(numeric) vector of length 2 representing the lower and upper limits of the reference interval}

\item{RIperc}{(numeric) value specifying the percentiles, which define the reference interval (default c(0.025, 0.975))}

\item{CIprop}{(numeric) specifying the width of the confidence interval used to determine Equivalence Limits (default 0.9)}

\item{pCVA.exp}{(numeric) value greater than 0 representing the exponent for the calculation of pCV.A}

\item{with.bias}{(logical) value indicating whether to consider bias according to Haekel 2015}

\item{n}{(numeric) value representing the sample size for consideration of bias}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{	(data.frame) containing the calculated equivalence limits
}\if{html}{\out{</div>}}
}
\description{
Calculate equivalence limits
}
\author{
Matthias Beck \email{matthias.beck.mb1@roche.com}
}
