% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice}
\alias{slice}
\title{Create a Reference Slice to a Vector}
\usage{
slice(x, ...)
}
\arguments{
\item{x}{object to be referenced; must be a symbol or character}

\item{...}{objects passed to \code{x[...]} when dereferenced}
}
\value{
object of class \code{"slice"} and \code{"ref"}
}
\description{
Create a reference to a 'part' of an R object. Use \code{\link{deref}} or \code{`!`} to obtain the values
within the referenced object.
}
\details{
\code{slice} is similar to \code{\link{ref}}; it creates a reference to another R object. There are two
main differences with \code{ref}. First, \code{slice} only accepts names or characters instead of
expressions. Second, \code{slice} records a part of the underlying object. \code{slice(x, 1:2, 3)}
is equivalent to the reference of \code{x[1:2, 3]}. This is similar to \code{ref(x[1:2, 3])}, though the
implementation is different. \code{ref} would create an expression with a reference to \code{x}, while
\code{slice(x, 1:2, 3)} creates a list with a reference to \code{x} and the extract inputs. \code{slice}
is more efficient, but is limited in its capabilities.
}
\examples{
## Vector Slice
x <- 10:1

slice_x <- slice(x, 2:4)
identical(!slice_x, 9:7)   # TRUE

x <- x - 2
identical(!slice_x, 7:5)   # TRUE

## Matrix Slice
y <- matrix(1:9, nrow=3)
slice_y <- slice(y, 2, 3)

identical(!slice_y, y[2, 3])   # TRUE
}
