% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{match_cond.ref}
\alias{match_cond.ref}
\alias{match_cond.sref}
\alias{match_cond.slice}
\alias{match_cond.rfexpr}
\title{Check and Evaluate Match Condition}
\usage{
\method{match_cond}{ref}(cond, x, do, ...)

\method{match_cond}{sref}(cond, x, do, ...)

\method{match_cond}{slice}(cond, x, do, ...)

\method{match_cond}{rfexpr}(cond, x, do, ...)
}
\arguments{
\item{cond}{match condition}

\item{x}{object being matched}

\item{do}{return expression associated with the condition. If \code{cond} is matched with \code{x}, then \code{do}
should be evaluated and returned in a list with \code{TRUE}: \code{list(TRUE, eval(do))}.}

\item{...}{arguments passed to evaluation}
}
\value{
\code{FALSE} if no match, or a list containing \code{TRUE} and the evaluated expression
}
\description{
\code{\link{ref}} methods for use with \code{\link[matchr]{Match}} in the \code{matchr} package.
}
\details{
See \code{\link[matchr]{Match}} for details about the implementation of \code{match_cond}. When matching,
\code{ref} conditions check whether \code{x} is a \code{ref} object. If so, then a match occurs if the condition
and \code{x} point to the same object. Otherwise, the condition is dereferenced and the resulting value
is checked using the appropriate match condition. Note that a \code{\link{slice}} is never matched with a
\code{\link{ref}} and vice versa, though \code{\link{ref}} and \code{\link{sref}} objects may match if they
point to the same object.
}
\examples{
x <- 1:10
ref_to_x <- ref(x)

matchr::Match(
  x,
  is.character -> "is a character",
  ref_to_x     -> "same as reference",   # <- MATCH
  .            -> "anything else"
)

}
