% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redis_tools.R
\name{redis_info}
\alias{redis_info}
\alias{parse_info}
\alias{redis_version}
\title{Parse Redis \code{INFO}}
\usage{
redis_info(con)

parse_info(x)

redis_version(con)
}
\arguments{
\item{con}{A Redis connection}

\item{x}{character string}
}
\description{
Parse and return Redis \code{INFO} data.
}
\examples{
\dontshow{if (redux::redis_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
r <- redux::hiredis()

# Redis server version:
redux::redis_version(r)
# This is a 'numeric_version' object so you can compute with it
# if you need to check for minimum versions
redux::redis_version(r) >= numeric_version("2.1.1")

# Extensive information is given back by the server:
redux::redis_info(r)

# Which is just:
redux::parse_info(r$INFO())
\dontshow{\}) # examplesIf}
}
