% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{rec.average}
\alias{rec.average}
\title{REC Metric 1}
\usage{
rec.average(data, na.rm = TRUE)
}
\arguments{
\item{data}{A data.frame or tibble  (required)}

\item{na.rm}{logical (defaults to TRUE)}
}
\value{
A single numerical value
}
\description{
The average of the absolute values of the C-REC matrix entries (this is
essentially how much relative excess correlation there is still to distribute
across groupings)
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
{
  # Use the SCWB data example
  # Metric 1 - item scores
  rec.average(SCWB[, 1:20])
  # Metric 4 - domain total scores
  my_rec <- rec.average(SCWB[, 21:25])
  my_rec
  # Metric 4 - averages
  mean(abs(my_rec[lower.tri(my_rec)]))
}
}
