% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_compare_pairs.R, R/compare_pairs.R
\name{compare_pairs.cluster_pairs}
\alias{compare_pairs.cluster_pairs}
\alias{compare_pairs}
\alias{compare_pairs.pairs}
\title{Compare pairs on a set of variables common in both data sets}
\usage{
\method{compare_pairs}{cluster_pairs}(
  pairs,
  on,
  comparators = list(default_comparator),
  default_comparator = cmp_identical(),
  new_name = NULL,
  ...
)

compare_pairs(
  pairs,
  on,
  comparators = list(default_comparator),
  default_comparator = cmp_identical(),
  ...
)

\method{compare_pairs}{pairs}(
  pairs,
  on,
  comparators = list(default_comparator),
  default_comparator = cmp_identical(),
  x = attr(pairs, "x"),
  y = attr(pairs, "y"),
  inplace = FALSE,
  ...
)
}
\arguments{
\item{pairs}{\code{\link[data.table]{data.table}} with pairs. Should contain the columns 
\code{.x} and \code{.y}.}

\item{on}{character vector of variables that should be compared.}

\item{comparators}{named list of functions with which the variables are compared. 
This function should accept two vectors. Function should either return a vector
or a \code{data.table} with multiple columns.}

\item{default_comparator}{variables for which no comparison function is defined using
\code{comparators} is compares with the function \code{default_comparator}.}

\item{new_name}{name of new object to assign the pairs to on the cluster
nodes.}

\item{...}{Ignored for now}

\item{x}{\code{data.table} with one half of the pairs.}

\item{y}{\code{data.table} with the other half of the pairs.}

\item{inplace}{logical indicating whether \code{pairs} should be modified in place. When
pairs is large this can be more efficient.}
}
\value{
Returns the \code{data.table} \code{pairs} with one or more columns added in
case of \code{compare_pairs.pairs}. 

In case of \code{compare_pairs.cluster_pairs}, \code{compare_pair.pairs} is called on
each cluster node and the resulting pairs are assigned to \code{new_name} in
the environment \code{reclin_env}. When \code{new_name} is not given (or
equal to NULL) the original pairs on the nodes are overwritten.
}
\description{
Compare pairs on a set of variables common in both data sets
}
\details{
It is assumed the variables in \code{on} are present in both \code{x} and \code{y}. Variables
with the same names are added to pairs. 
When the \code{comparator} returns a \code{data.table} multiple columns are added to \code{pairs}. 
The names of these columns are \code{variable} pasted together with the names of 
the \code{data.table} returned by \code{comparator} (separated by "_").
}
