% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_missing.R
\name{step_filter_missing}
\alias{step_filter_missing}
\title{Missing value column filter}
\usage{
step_filter_missing(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  threshold = 0.1,
  removals = NULL,
  skip = FALSE,
  id = rand_id("filter_missing")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{threshold}{A value for the threshold of missing values in column. The
step will remove the columns where the proportion of missing values exceeds
the threshold.}

\item{removals}{A character string that contains the names of columns that
should be removed. These values are not determined until \code{\link[=prep]{prep()}} is
called.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[=bake]{bake()}}? While all operations are baked when \code{\link[=prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_filter_missing()} creates a \emph{specification} of a recipe step that will
potentially remove variables that have too many missing values.
}
\details{
This step can potentially remove columns from the data set. This may
cause issues for subsequent steps in your recipe if the missing columns are
specifically referenced by name. To avoid this, see the advice in the
\emph{Tips for saving recipes and filtering columns} section of \link{selections}.

This step will remove variables if the proportion of missing values exceeds
the \code{threshold}.

All variables with missing values will be removed for \code{threshold = 0}.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms} and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{id}{character, id of this step}
}
}

\section{Tuning Parameters}{
This step has 1 tuning parameters:
\itemize{
\item \code{threshold}: Threshold (type: double, default: 0.1)
}
}

\section{Sparse data}{


This step can be applied to \link{sparse_data} such that it is preserved. Nothing
needs to be done for this to happen as it is done automatically.
}

\section{Case weights}{


This step performs an unsupervised operation that can utilize case weights.
As a result, case weights are only used with frequency weights. For more
information, see the documentation in \link{case_weights} and the examples on
\code{tidymodels.org}.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(credit_data, package = "modeldata")

rec <- recipe(Status ~ ., data = credit_data) |>
  step_filter_missing(all_predictors(), threshold = 0)

filter_obj <- prep(rec)

filtered_te <- bake(filter_obj, new_data = NULL)

tidy(rec, number = 1)
tidy(filter_obj, number = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other variable filter steps: 
\code{\link{step_corr}()},
\code{\link{step_lincomb}()},
\code{\link{step_nzv}()},
\code{\link{step_rm}()},
\code{\link{step_select}()},
\code{\link{step_zv}()}
}
\concept{variable filter steps}
