# rechaRge [![CRAN status](https://www.r-pkg.org/badges/version/rechaRge)](https://CRAN.R-project.org/package=rechaRge) [![R-CMD-check](https://github.com/gwrecharge/rechaRge/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/gwrecharge/rechaRge/actions/workflows/R-CMD-check.yaml)

> The results of the survey used to assess the community expectations regarding this package are presented here: https://github.com/gwrecharge/rechaRge-book/blob/main/community_survey/survey_main_results.md 

## Installation

Using `remotes`

```r
remotes::install_github("gwrecharge/rechaRge", ref = "main")
```

OR using `pak`

```r
pak::pkg_install("gwrecharge/rechaRge@main")
```

## Documentation

In addition with the online [rechaRge package documentation](https://gwrecharge.github.io/rechaRge/), a book is also available with detailed explanations and examples, see [rechaRge: the HydroBudget model](https://gwrecharge.github.io/rechaRge-book/).

## Example

See [hydrobudget-example-simulation.R](https://github.com/gwrecharge/rechaRge-book/blob/main/examples/hydrobudget-example-simulation.R) and [hydrobudget-example-calibration.R](https://github.com/gwrecharge/rechaRge-book/blob/main/examples/hydrobudget-example-calibration.R).

## Publication

Original material from the publication **HydroBudget – Groundwater recharge model in R** [https://doi.org/10.5683/SP3/EUDV3H](https://doi.org/10.5683/SP3/EUDV3H).

