% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdhotspotlist.R
\name{ebirdhotspotlist}
\alias{ebirdhotspotlist}
\title{Hotspots in a region or nearby coordinates}
\usage{
ebirdhotspotlist(
  regionCode = NULL,
  lat = NULL,
  lng = NULL,
  dist = NULL,
  back = NULL,
  sleep = 0,
  key = NULL,
  ...
)
}
\arguments{
\item{regionCode}{The country, subnational1 or subnational2 code. If `regionCode` is provided then 
latitude and longitude are ignored.}

\item{lat}{Decimal latitude. value between -90.00 and 90.00, up to two
decimal places of precision. Defaults to latitude based on IP if neither `regionCode` 
nor `lat` and `lng` are provided.}

\item{lng}{Decimal longitude. value between -180.00 and 180.00, up to
two decimal places of precision. Defaults to longitude based on IP if neither `regionCode` 
nor `lat` and `lng` are provided.}

\item{dist}{The search radius from the given set of coordinates, in kilometers (between 0 and 500, defaults to 25).}

\item{back}{Only fetch hotspots which have been visited up to 'back' days ago (defaults to `NULL`).}

\item{sleep}{Time (in seconds) before function sends API call (defaults to
zero. Set to higher number if you are using this function in a loop with
many API calls).}

\item{key}{eBird API key. You can obtain one from https://ebird.org/api/keygen.
We strongly recommend storing it in your \code{.Renviron} file as an 
environment variable called \code{EBIRD_KEY}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A data.frame with ten columns containing:

"locId": unique identifier for the hotspot

"locName": hotspot name

"countryCode": country code

"subnational1Code": subnational1 code (state/province level)

"subnational2Code": subnational2 code (county/municipality level)

"lat": latitude of the hotspot

"lng": longitude of the hotspot

"latestObsDt": Date of latest observation

"numSpeciesAllTime": Total number of species recorded in the hotspot
}
\description{
Get the list of hotspots within a region, or within a radius of up to 50 kilometers, from a given set of coordinates.
}
\examples{
\dontrun{
ebirdhotspotlist("CA-NS-HL")
ebirdhotspotlist("VA")
ebirdhotspotlist(lat = 30, lng = -90, dist = 10)
library(httr)
ebirdhotspotlist("CA-NS-HL", config = verbose())
}
}
\references{
\url{http://ebird.org/}
}
\author{
Sebastian Pardo \email{sebpardo@gmail.com},
   David Bradnum \email{dbradnum@gmail.com}
}
