% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_checks.R
\name{sd_prior_checks}
\alias{sd_prior_checks}
\title{Prior predictive checks}
\usage{
sd_prior_checks(
  filepath,
  meas_mdl,
  estimated_params,
  n_draws,
  start_time = NULL,
  stop_time = NULL,
  timestep = NULL,
  integ_method = "euler"
)
}
\arguments{
\item{filepath}{A string that indicates a path to a file with extension .stmx
or .xmile. Vensim files (.mdl) are not xmile files. They must be exported
from Vensim with extension .xmile}

\item{meas_mdl}{A list of strings. Each string corresponds to a sampling
statement written in Stan language.}

\item{estimated_params}{A list of lists. Each sublist describes each
parameter that will be estimated in the inference stage. To construct this
description, the user can avail of the function `sd_prior`.}

\item{n_draws}{An integer that indicates how many time-series will be
returned.}

\item{start_time}{A number indicating the time at which the simulation begins.}

\item{stop_time}{A number indicating the time at which the simulation ends.}

\item{timestep}{A number indicating the time interval for the simulation.
Also known as \code{dt}.}

\item{integ_method}{A string indicating the integration method. It can be
either "euler" or "rk4"}
}
\value{
A list of two data frames.
}
\description{
Prior predictive checks
}
\examples{
  filepath <- system.file("models/", "SEIR.stmx", package = "readsdr")
  meas_mdl   <- list("y ~ neg_binomial_2(net_flow(C), phi)")
  estimated_params <- list(
    sd_prior("par_beta", "lognormal", c(0, 1)),
    sd_prior("par_rho", "beta", c(2, 2)),
    sd_prior("I0", "lognormal", c(0, 1), "init"))
  sd_prior_checks(filepath, meas_mdl, estimated_params, n_draws = 2,
   start_time = 0, stop_time = 5,
   integ_method = "rk4", timestep = 1/32)
}
