% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pptx.R
\name{read_pptx}
\alias{read_pptx}
\title{Read data from a Modern PowerPoint File}
\usage{
read_pptx(pptx)
}
\arguments{
\item{pptx}{The .pptx file to read}
}
\value{
List containing slide elements.
}
\description{
Read data from a Modern PowerPoint File
}
\details{
Only accepts one file at a time and only .pptx files.  Modifying file extensions will not work.

The returned list contains named lists of the elements on the slide, each element of which is either a data.frame or a matrix containing the text and minor details about the structure on the page.

Data frames will contain the text in addition to the following columns:
"Bulleted" indicates if the text is part of a bulleted or numbered list on the slide.
"Hierarchy" indicates the tabbed depth of the element in a bulleted or numbered list (NA if not bulleted).

Alternatively, returns a matrix for tables on the slide.
}
\examples{
read_pptx(system.file('extdata','example.pptx',package='readOffice'))

}
