% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{hoverdark}
\alias{hoverdark}
\title{Theme hoverdark}
\usage{
hoverdark(
  font_size = 15,
  font_color = "#222222",
  header_font_size = 15,
  cell_padding = 4,
  centered = FALSE
)
}
\arguments{
\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{font_color}{Color of the font for the text within the table.
Default is #222222.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 4.}

\item{centered}{Logical: vertically center the contents of the table.
Default is FALSE.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
Changes from light-themed to dark-themed on hover
}
\examples{
data <- iris[10:29, ]

## Standard hoverdark theme
reactable(data,
          theme = hoverdark())

## Additional options applied
reactable(data,
          theme = hoverdark(font_size = 12, font_color = "grey", cell_padding = 3))

}
