% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{dark}
\alias{dark}
\title{Theme dark}
\usage{
dark(
  font_size = 15,
  font_color = "#FFFFFF",
  header_font_size = 16,
  header_font_color = "#FFFFFF",
  cell_padding = 6,
  centered = FALSE
)
}
\arguments{
\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #FFFFFF.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 16.}

\item{header_font_color}{Color of the font for the header text.
Default is #FFFFFF.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}

\item{centered}{Logical: vertically center the contents of the table.
Default is FALSE.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
dark table theme
}
\examples{
data <- iris[10:29, ]

## Standard dark theme
reactable(data,
          theme = dark())

## Additional options applied
reactable(data,
          theme = dark(font_size = 12, font_color = "red", cell_padding = 3))

}
