% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{cosmo}
\alias{cosmo}
\title{Theme cosmo}
\usage{
cosmo(
  font_size = 14,
  font_color = "#141415",
  header_font_size = 15,
  header_font_color = "#ffffff",
  cell_padding = 6,
  centered = FALSE
)
}
\arguments{
\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 14.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #141415.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{header_font_color}{Color of the font for the header text.
Default is #ffffff.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}

\item{centered}{Logical: vertically center the contents of the table.
Default is FALSE.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
Bootstrap-inspired cosmo theme
}
\examples{
data <- iris[10:29, ]

## Standard cosmo theme
reactable(data,
          theme = cosmo())

## Additional options applied
reactable(data,
          theme = cosmo(font_size = 12, font_color = "grey", cell_padding = 3))

}
