% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub.R
\name{re_sub}
\alias{re_sub}
\title{Substitute occurrences of a pattern in a string}
\usage{
re_sub(pattern, replacement, string, ...)
}
\arguments{
\item{pattern}{A regular expression pattern or a compiled pattern object.}

\item{replacement}{The replacement string.}

\item{string}{A character vector where each element is a string in which the pattern will be replaced.}

\item{...}{
  Arguments passed on to \code{\link[=re_compile]{re_compile}}
  \describe{
    \item{\code{IGNORECASE}}{Flag to indicate case-insensitive matching.}
    \item{\code{I}}{Abbreviation for IGNORECASE.}
    \item{\code{MULTILINE}}{Flag to indicate multi-line matching, where \code{^} and \code{$} match the start and end of each line.}
    \item{\code{M}}{Abbreviation for MULTILINE.}
    \item{\code{DOTALL}}{Flag to indicate that \code{.} (dot) should match any character including newline.}
    \item{\code{S}}{Abbreviation for DOTALL}
    \item{\code{VERBOSE}}{Flag to allow a more verbose regex syntax, which can include comments and whitespace for readability.}
    \item{\code{X}}{Abbreviation for VERBOSE}
    \item{\code{NOFLAG}}{Flag to indicate that no flags should be set.}
  }}
}
\value{
A character vector of the same length as \code{string}, with all occurrences of the pattern replaced by
\code{replacement} in each element.
}
\description{
\code{re_sub} replaces all occurrences of a specified pattern (regular expression) in each element of a
character vector with a replacement string. If the provided pattern is not already a compiled pattern object, it
compiles it using \code{re_compile}.
}
\examples{
pattern <- re_compile("\\\\d+")
re_sub(pattern, "number", "Replace 123 with text.") # Replaces "123" with "number"
re_sub("\\\\s+", "-", "Split and join") # Replaces spaces with hyphens
}
\seealso{
\href{https://docs.python.org/3/library/re.html#re.sub}{Python re.sub() documentation}
}
