% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{re_split}
\alias{re_split}
\title{Split a string by a regular expression pattern}
\usage{
re_split(pattern, string, ..., maxsplit = -1L)
}
\arguments{
\item{pattern}{A regular expression pattern or a compiled pattern object.}

\item{string}{A character vector where each element is a string to be split.}

\item{...}{
  Arguments passed on to \code{\link[=re_compile]{re_compile}}
  \describe{
    \item{\code{IGNORECASE}}{Flag to indicate case-insensitive matching.}
    \item{\code{I}}{Abbreviation for IGNORECASE.}
    \item{\code{MULTILINE}}{Flag to indicate multi-line matching, where \code{^} and \code{$} match the start and end of each line.}
    \item{\code{M}}{Abbreviation for MULTILINE.}
    \item{\code{DOTALL}}{Flag to indicate that \code{.} (dot) should match any character including newline.}
    \item{\code{S}}{Abbreviation for DOTALL}
    \item{\code{VERBOSE}}{Flag to allow a more verbose regex syntax, which can include comments and whitespace for readability.}
    \item{\code{X}}{Abbreviation for VERBOSE}
    \item{\code{NOFLAG}}{Flag to indicate that no flags should be set.}
  }}

\item{maxsplit}{The maximum number of splits to perform on each string. If -1L (default), all possible splits are
performed.}
}
\value{
A list of character vectors, where each vector contains the substrings resulting from splitting the
corresponding element of \code{string}.
}
\description{
\code{re_split} splits each element of a character vector into substrings based on a specified pattern
(regular expression). If the provided pattern is not already a compiled pattern object, it compiles it using
\code{re_compile}. The function allows for controlling the maximum number of splits performed.
}
\examples{
pattern <- re_compile("\\\\s+")
re_split(pattern, "Split this string") # Splits on whitespace
re_split("\\\\W+", "Split,with!punctuation.morestuff", maxsplit = 2)
}
\seealso{
\href{https://docs.python.org/3/library/re.html#re.split}{Python re.split() documentation}
}
