% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{re2_count}
\alias{re2_count}
\title{Count the number of matches in a string}
\usage{
re2_count(string, pattern)
}
\arguments{
\item{string}{A character vector, or an object which can be coerced to one.}

\item{pattern}{Character string containing a regular expression,
 or a pre-compiled regular expression (or a vector of character
 strings and pre-compiled regular expressions). \cr
See \code{\link{re2_regexp}} for available options. \cr
See \link{re2_syntax} for regular expression syntax. \cr}
}
\value{
An integer vector.
}
\description{
Vectorized over string and pattern. Match against a string using a regular
   expression and return the count of matches.
}
\examples{
color <- c("yellowgreen", "steelblue", "goldenrod", "forestgreen")
re2_count(color, "e")
re2_count(color, "r")

# Regular expression vs literal string
re2_count(c("..", "a...", "foo.b"), ".")
re2_count(c("..", "a...", "foo.b"), re2_regexp(".", literal = TRUE))
}
\seealso{
\code{\link{re2_regexp}} for options to regular expression,
  \link{re2_syntax} for regular expression syntax.
}
