% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_to_raster.R
\name{coord_to_raster}
\alias{coord_to_raster}
\title{Turn coordinates of outlets into rasters}
\usage{
coord_to_raster(outlets, which, out, overwrite = FALSE)
}
\arguments{
\item{outlets}{The name of a set of sites in the current GRASS mapset.}

\item{which}{A numeric identifier for the site to convert to raster.}

\item{out}{The file name of the output outlet raster in the current GRASS mapset.}

\item{overwrite}{Whether the output files should be allowed to overwrite existing files. Defaults to \code{FALSE}.}
}
\value{
Nothing.
}
\description{
Given a set of x-y coordinates, this function will return a raster with a single cell at those coordinates.
}
\details{
This function is exposed to the user, and users are welcome to use if convenient for them, this function is intended for internal use in other functions.
}
\examples{
# Will only run if GRASS is running
if(check_running()){
# Load data set
dem <- system.file("extdata", "dem.tif", package = "rdwplus")
sts <- system.file("extdata", "sites.shp", packages = "rdwplus")

# Set environment parameters
set_envir(dem)

# Read in sites
vector_to_mapset(sts)

# Convert first site to raster
coord_to_raster("site", 1, "coords", overwrite = TRUE)
}
}
