% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locdir.R
\name{locdir}
\alias{locdir}
\title{local data directory}
\usage{
locdir(dir = getOption("rdwdlocdir"), file = NULL, quiet = rdwdquiet())
}
\arguments{
\item{dir}{Path to data directory.
If \code{dir} is NULL, locdir tries "C:/DWDdata", then "~/DWDdata",
then \link[tools:userdir]{tools::R_user_dir}\verb{("rdwd", which="cache")}.\cr\cr
\code{dir} can also be set with
\code{options(rdwdlocdir="YOUR/PATH")} thanks to the
DEFAULT: \link[R.utils:Non-documented_objects]{R.utils::getOption}\code{("rdwdlocdir")}}

\item{file}{Optional: path(s) at \code{dir}. DEFAULT: NULL}

\item{quiet}{Ignored since version 1.9.4 (2025-10-20).
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}
}
\value{
charstring (directory)
}
\description{
Get the directory for DWD data across projects,
thus avoiding multiple downloads of the same file.\cr
Set the default for all subsequent calls with \code{options(rdwdlocdir="YOUR/PATH")}.\cr
You could add this to your .Rprofile file e.g. via \code{usethis::edit_r_profile()}\cr
}
\examples{
locdir()
oldopt <- options(rdwdlocdir="~")
locdir()
stopifnot(locdir() == path.expand("~"))
options(oldopt) ; rm(oldopt)

}
\seealso{
\code{\link[=dataDWD]{dataDWD()}}, \code{\link[=runLocalTests]{runLocalTests()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Apr 2019, Jun 2021, Oct 2025
}
\keyword{file}
