% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_daily_decomp.R
\name{ts_daily_decomp}
\alias{ts_daily_decomp}
\title{Time Series Forecast and Decomposition for Daily Crime Data}
\usage{
ts_daily_decomp(data, start)
}
\arguments{
\item{data}{Data frame of crime or RMS data. See provided Chicago Data Portal
example for reference}

\item{start}{Start date for the time series being analyzed. The format is as
follows: c('year', 'month', 'day'). See example below for reference.}
}
\value{
Returns an object of class "stl" with the following components:

time.series: a multiple time series with columns seasonal, trend and remainder.

weights: the final robust weights (all one if fitting is not done robustly).

call: the matched call.

win: integer (length 3 vector) with the spans used for the "s", "t", and "l" smoothers.

deg: integer (length 3) vector with the polynomial degrees for these smoothers.

jump: integer (length 3) vector with the 'jumps' (skips) used for these smoothers.

inner: number of inner iterations
}
\description{
This function transforms daily crime count data and plots the
    resultant components of a time series which has been decomposed into
    seasonal, trend, and irregular components using Loess smoothing. Holt
    Winters exponential smoothing is also performed for inproved trend
    resolution since data is in a daily format.
}
\examples{
#Using provided dataset from Chicago Data Portal:
data(crimes)
test <- ts_daily_decomp(data = crimes, start = c(2017, 1, 1))
plot(test)
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{ts}
