% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{combine_query_boolean}
\alias{combine_query_boolean}
\title{Combine a database query with a cohort returning a 0/1 vector depending on whether each individual has a recorded code of interest.}
\usage{
combine_query_boolean(
  db_query,
  cohort,
  query_type = c("med", "drug"),
  time_prev = Inf,
  time_post = 0,
  numobs = 1
)
}
\arguments{
\item{db_query}{Output from database query (ideally obtained through \code{\link{db_query}}).}

\item{cohort}{Cohort to combine with the database query.}

\item{query_type}{Type of query}

\item{time_prev}{Number of days prior to index date to look for codes.}

\item{time_post}{Number of days after index date to look for codes.}

\item{numobs}{Number of observations required to be observed in specified time window to return a 1.}
}
\value{
A 0/1 vector.
}
\description{
An S3 generic function that can be used on database queries from Aurum or GOLD extracts.
Combine a database query with a cohort returning a 0/1 vector depending on whether each individual has a recorded code of interest.
\code{cohort} must contain variables \code{patid} and \code{indexdt}. The database query will be merged with the cohort by variable \code{patid}.
If an individual has at least \code{numobs} observations between \code{time_prev} days prior to \code{indexdt}, and \code{time_post} days after
\code{indexdt}, a 1 will be returned, 0 otherwise. The \code{type} of query must be specified for appropriate data manipulation.
}
