% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{stack}
\alias{stack}
\title{Run a stack of \code{TROLL} simulations}
\usage{
stack(
  name = NULL,
  simulations,
  path = NULL,
  global,
  species,
  climate,
  daily,
  lidar = NULL,
  forest = NULL,
  load = TRUE,
  cores = NULL,
  verbose = TRUE,
  overwrite = TRUE,
  thin = NULL
)
}
\arguments{
\item{name}{char. Stack name (if NULL the timestamp will be used).}

\item{simulations}{char. Simulation names (corrsponding to simulation indexes
in orresponding tables, see example below).}

\item{path}{char. Path to save the stack of simulation outputs (parent
folder), the default is null corresponding to a simulation in memory
without saved intermediary files (based on temporary files from
\link{option.rcontroll}).}

\item{global}{df. Global parameters (e.g. \link{TROLLv3_input} or using
\code{\link[=generate_parameters]{generate_parameters()}}).}

\item{species}{df. Species parameters (e.g. \link{TROLLv3_species}).}

\item{climate}{df. Climate parameters (e.g. \link{TROLLv3_climatedaytime12}).}

\item{daily}{df. Daily variation parameters (e.g. \link{TROLLv3_daytimevar}).}

\item{lidar}{df. Lidar simulation parameters (e.g. using \code{\link[=generate_lidar]{generate_lidar()}}),
if null not computed (default NULL).}

\item{forest}{df. TROLL with forest input, if null starts from an empty grid
(default NULL) (e.g. using \link{TROLLv3_output} with \code{\link[=get_forest]{get_forest()}}).}

\item{load}{bool. TROLL outputs are loaded in R memory, if not only the path
and name of the stack of simulations is kept in the resulting
\code{\link[=trollstack]{trollstack()}} object but the content can be accessed later using the
\code{\link[=load_sim]{load_sim()}} method.}

\item{cores}{int. Number of cores for parallelization, if NULL available
cores - 1 (default NULL). You can use \code{\link[parallel:detectCores]{parallel::detectCores()}} to know
available cores on your machine.}

\item{verbose}{bool. Show TROLL log in the console.}

\item{overwrite}{bool. Overwrite previous outputs folder and files.}

\item{thin}{int. Vector of integers corresponding to the iterations to be
kept to reduce output size, default is NULL and corresponds to no thinning.}
}
\value{
A \code{\link[=trollstack]{trollstack()}} object.
}
\description{
\code{stack()} run a stack of \code{TROLL} simulation. The minimal set of input files
required for a \code{TROLL} run include (i) climate data for the focal location
(\code{climate} and \code{daily}), (ii) functional traits for the list of species at
the focal location (\code{species}), and (iii) global parameters (\code{global}), i.e.
parameters that do not depend on species identity.
}
\examples{
\dontrun{
data("TROLLv3_species")
data("TROLLv3_climatedaytime12")
data("TROLLv3_daytimevar")
data("TROLLv3_output")
TROLLv3_input_stack <- generate_parameters(
  cols = 100, rows = 100,
  iterperyear = 12, nbiter = 12 * 1
) \%>\%
  mutate(simulation = list(c("seed50000", "seed500"))) \%>\%
  unnest(simulation)
TROLLv3_input_stack[62, 2] <- 500 # Cseedrain
stack(
  name = "teststack",
  simulations = c("seed50000", "seed500"),
  global = TROLLv3_input_stack,
  species = TROLLv3_species,
  climate = TROLLv3_climatedaytime12,
  daily = TROLLv3_daytimevar,
  load = TRUE,
  cores = 2,
  verbose = FALSE,
  thin = c(1, 5, 10)
)
}

}
\seealso{
\code{\link[=troll]{troll()}}
}
