% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_compendium.R
\name{add_compendium}
\alias{add_compendium}
\title{Create additional folders}
\usage{
add_compendium(compendium = NULL, quiet = FALSE)
}
\arguments{
\item{compendium}{A character vector specifying the folders to be created.}

\item{quiet}{A logical value. If \code{TRUE} messages are deleted. Default is
\code{FALSE}.}
}
\value{
No return value.
}
\description{
This function creates a compendium, i.e. additional folders to a package
structure. By default, the following directories are created:
\code{data}, \verb{analyses/}, \verb{outputs/}, and  \verb{figures/}. A \code{README.md} is added to
each folder and must be edited. The argument \code{compendium} allows user to
hoose its own compendium structure. All theses folders are added to the
\code{.Rbuildignore} file.
}
\examples{
\dontrun{
add_compendium()
add_compendium(compendium = "paper")
add_compendium(compendium = c("data", "outputs", "code", "manuscript"))
}
}
\seealso{
Other create files: 
\code{\link{add_citation}()},
\code{\link{add_code_of_conduct}()},
\code{\link{add_contributing}()},
\code{\link{add_description}()},
\code{\link{add_dockerfile}()},
\code{\link{add_license}()},
\code{\link{add_makefile}()},
\code{\link{add_package_doc}()},
\code{\link{add_readme_rmd}()},
\code{\link{add_renv}()},
\code{\link{add_testthat}()},
\code{\link{add_vignette}()}
}
\concept{create files}
