/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.renderer.generators.standard.ConvexHull;
import org.openscience.cdk.renderer.generators.standard.TextOutline;

final class AtomSymbol {
    private final TextOutline element;
    private final List<TextOutline> adjuncts;
    private final List<TextOutline> annotationAdjuncts;
    private final SymbolAlignment alignment;
    private final ConvexHull hull;

    AtomSymbol(TextOutline element, List<TextOutline> adjuncts) {
        this.element = element;
        this.adjuncts = adjuncts;
        this.annotationAdjuncts = new ArrayList<TextOutline>();
        this.alignment = SymbolAlignment.Center;
        this.hull = ConvexHull.ofShapes(this.getOutlines());
    }

    private AtomSymbol(TextOutline element, List<TextOutline> adjuncts, List<TextOutline> annotationAdjuncts, SymbolAlignment alignment, ConvexHull hull) {
        this.element = element;
        this.adjuncts = adjuncts;
        this.annotationAdjuncts = annotationAdjuncts;
        this.alignment = alignment;
        this.hull = hull;
    }

    AtomSymbol alignTo(SymbolAlignment alignment) {
        return new AtomSymbol(this.element, this.adjuncts, this.annotationAdjuncts, alignment, this.hull);
    }

    AtomSymbol addAnnotation(TextOutline annotation) {
        ArrayList<TextOutline> newAnnotations = new ArrayList<TextOutline>(this.annotationAdjuncts);
        newAnnotations.add(annotation);
        return new AtomSymbol(this.element, this.adjuncts, newAnnotations, this.alignment, this.hull);
    }

    Point2D getAlignmentCenter() {
        if (this.alignment == SymbolAlignment.Left) {
            return this.element.getFirstGlyphCenter();
        }
        if (this.alignment == SymbolAlignment.Right) {
            return this.element.getLastGlyphCenter();
        }
        return this.element.getCenter();
    }

    TextOutline elementOutline() {
        return this.element;
    }

    List<TextOutline> adjunctOutlines() {
        return Collections.unmodifiableList(this.adjuncts);
    }

    List<Shape> getOutlines() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        shapes.add(this.element.getOutline());
        for (TextOutline adjunct : this.adjuncts) {
            shapes.add(adjunct.getOutline());
        }
        return shapes;
    }

    List<Shape> getAnnotationOutlines() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        for (TextOutline adjunct : this.annotationAdjuncts) {
            shapes.add(adjunct.getOutline());
        }
        return shapes;
    }

    ConvexHull getConvexHull() {
        return this.hull;
    }

    AtomSymbol transform(AffineTransform transform) {
        ArrayList<TextOutline> transformedAdjuncts = new ArrayList<TextOutline>(this.adjuncts.size());
        for (TextOutline adjunct : this.adjuncts) {
            transformedAdjuncts.add(adjunct.transform(transform));
        }
        ArrayList<TextOutline> transformedAnnAdjuncts = new ArrayList<TextOutline>(this.adjuncts.size());
        for (TextOutline adjunct : this.annotationAdjuncts) {
            transformedAnnAdjuncts.add(adjunct.transform(transform));
        }
        return new AtomSymbol(this.element.transform(transform), transformedAdjuncts, transformedAnnAdjuncts, this.alignment, this.hull.transform(transform));
    }

    AtomSymbol resize(double scaleX, double scaleY) {
        Point2D center = this.element.getCenter();
        AffineTransform transform = new AffineTransform();
        transform.translate(center.getX(), center.getY());
        transform.scale(scaleX, scaleY);
        transform.translate(-center.getX(), -center.getY());
        return this.transform(transform);
    }

    AtomSymbol center(double x, double y) {
        Point2D center = this.getAlignmentCenter();
        return this.translate(x - center.getX(), y - center.getY());
    }

    AtomSymbol translate(double x, double y) {
        return this.transform(AffineTransform.getTranslateInstance(x, y));
    }

    static enum SymbolAlignment {
        Left,
        Center,
        Right;

    }
}

