/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;

public class BasicGenerator
implements IGenerator<IAtomContainer> {
    private final BasicSceneGenerator sceneGenerator;
    private final BasicAtomGenerator atomGenerator = new BasicAtomGenerator();
    private final BasicBondGenerator bondGenerator = new BasicBondGenerator();

    public BasicGenerator() {
        this.sceneGenerator = new BasicSceneGenerator();
    }

    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        ElementGroup diagram = new ElementGroup();
        diagram.add(this.sceneGenerator.generate(ac, model));
        diagram.add(this.bondGenerator.generate(ac, model));
        diagram.add(this.atomGenerator.generate(ac, model));
        return diagram;
    }

    public List<IGeneratorParameter<?>> getParameters() {
        ArrayList list = new ArrayList();
        list.addAll(this.atomGenerator.getParameters());
        list.addAll(this.bondGenerator.getParameters());
        list.addAll(this.sceneGenerator.getParameters());
        return list;
    }
}

