% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.compositeKDE}
\alias{plot.compositeKDE}
\title{Plots a Composite Kernel Density Estimate of sampled radiocarbon dates.}
\usage{
\method{plot}{compositeKDE}(
  x,
  calendar = "BP",
  type = "envelope",
  ylim = NA,
  xlim = NA,
  fill.col = "lightgrey",
  interval = 0.95,
  line.col = "black",
  line.type = 2,
  multiline.alpha = NA,
  multiline.col = "black",
  ...
)
}
\arguments{
\item{x}{A \code{compositeKDE} class object generated using the \code{\link[rcarbon]{ckde}} function.}

\item{calendar}{Either \code{'BP'} or \code{'BCAD'}. Indicate whether the calibrated date should be displayed in BP or BC/AD. Default is  \code{'BP'}.}

\item{type}{Either \code{envelope} or \code{multiline}. Default is \code{envelope}.}

\item{ylim}{the y limits of the plot.}

\item{xlim}{the x limits of the plot. In BP or in BC/AD depending on the choice of the parameter \code{calender}. Notice that if BC/AD is selected BC ages should have a minus sign (e.g. \code{c(-5000,200)} for 5000 BC to 200 AD).}

\item{fill.col}{Envelope color when \code{type='envelope'}. Default is 'lightgrey'.}

\item{interval}{Quantile interval for the envelope. Default is 0.95.}

\item{line.col}{Line color when \code{type='envelope'}. Default is 'black.}

\item{line.type}{Line type when \code{type='envelope'}. Default is 2.}

\item{multiline.alpha}{Alpha level for line transparency when \code{type='multiline'}. Default is 10/\code{nsim}, where \code{nsim} is the number of simulations. If \code{nsim} is smaller than 10, \code{multiline.alpha} will be set to 1.}

\item{multiline.col}{Line color when \code{type='multiline'}. Default is 'black'.}

\item{...}{Additional arguments affecting the plot}
}
\description{
Plots a Composite Kernel Density Estimate of sampled radiocarbon dates.
}
\details{
Visualise a \code{compositeKDE} class object. If \code{type} is set \code{'envelope'} an envelope of the percentile interval defined by the parameter \code{interval} is shown along with the mean KDE. If \code{type} is set \code{'multiline'} all KDEs are shown.
}
\seealso{
\code{\link[rcarbon]{ckde}};
}
