% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockchainRpcs.R
\name{getblock}
\alias{getblock}
\title{RPC-JSON API: getblock}
\usage{
getblock(con, blockhash, verbosity = c("l1", "l0", "l2"))
}
\arguments{
\item{con}{object of class \code{CONRPC}.}

\item{blockhash}{\code{character}, the block hash.}

\item{verbosity}{\code{character}, level of returned details.}
}
\value{
A S4-object of class \code{ANSRPC}.
}
\description{
Returns information of a block hash. The returned level of details depends on the
argument \code{verbosity}.
}

\details{
If verbosity is 'l0', returns a string that is serialized,
hex-encoded data for block 'hash'.
If verbosity is 'l1' (the default), returns an object with information about block <hash>.
If verbosity is 'l2', returns an object with information about block <hash> and
information about each transaction.
}

\references{
\url{https://bitcoin.org/en/developer-reference#getblock},
\url{https://bitcoin.org/en/developer-reference#remote-procedure-calls-rpcs}
}
\seealso{
Other Blockchain RPCs: \code{\link{decodescript}},
  \code{\link{getbestblockhash}},
  \code{\link{getblockchaininfo}},
  \code{\link{getblockcount}}, \code{\link{getblockhash}},
  \code{\link{getblockheader}}, \code{\link{getchaintips}},
  \code{\link{getchaintxstats}},
  \code{\link{getdifficulty}},
  \code{\link{getmempoolancestors}},
  \code{\link{getmempooldescendants}},
  \code{\link{getmempoolentry}},
  \code{\link{getmempoolinfo}},
  \code{\link{getrawmempool}}, \code{\link{gettxoutproof}},
  \code{\link{gettxoutsetinfo}}, \code{\link{gettxout}},
  \code{\link{preciousblock}},
  \code{\link{pruneblockchain}}, \code{\link{verifychain}},
  \code{\link{verifytxoutproof}}
}
\author{
Bernhard Pfaff
}
\concept{Blockchain RPCs}
