% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_mi_data.R
\name{summary.analysis}
\alias{summary.analysis}
\title{Summary Method for Analysis Objects}
\usage{
\method{summary}{analysis}(object, n_preview = 5, ...)
}
\arguments{
\item{object}{An object of class \code{analysis}.}

\item{n_preview}{Maximum number of parameters to show in the preview table.
Defaults to 5.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A list containing summary information (invisibly).
}
\description{
Provides a detailed summary of an analysis object from \code{\link[=analyse_mi_data]{analyse_mi_data()}}.
}
\examples{
\donttest{
library(rbmi)
library(rbmiUtils)
data("ADMI")

# Create analysis object
vars <- set_vars(
  subjid = "USUBJID", visit = "AVISIT", group = "TRT",
  outcome = "CHG", covariates = c("BASE", "STRATA")
)
method <- method_bayes(n_samples = 10, control = control_bayes(warmup = 10))

ana_obj <- analyse_mi_data(ADMI, vars, method, fun = function(d, v, ...) 1)
summary(ana_obj)
}

}
