% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_helpers.R
\name{prepare_data_ice}
\alias{prepare_data_ice}
\title{Prepare Intercurrent Event Data}
\usage{
prepare_data_ice(data, vars, ice_col, strategy)
}
\arguments{
\item{data}{A data.frame containing the analysis dataset.}

\item{vars}{A \code{vars} object as created by \code{\link[rbmi:set_vars]{rbmi::set_vars()}}.}

\item{ice_col}{Character string naming the column in \code{data} that indicates
ICE occurrence. Accepted values are logical (\code{TRUE}/\code{FALSE}), character
(\code{"Y"}/\code{"N"}), or numeric (\code{1}/\code{0}).}

\item{strategy}{Character string specifying the imputation strategy to assign.
Must be one of \code{"MAR"}, \code{"CR"}, \code{"JR"}, \code{"CIR"}, or \code{"LMCF"}.}
}
\value{
A data.frame with columns corresponding to \code{vars$subjid},
\code{vars$visit}, and \code{vars$strategy}, suitable for passing to
\code{\link[rbmi:draws]{rbmi::draws()}}.
}
\description{
Builds a \code{data_ice} data.frame from a column in the dataset that flags
intercurrent events. For each subject, the first visit (by factor level
order) where the flag is TRUE is used as the ICE visit.
}
\examples{
library(rbmi)

dat <- data.frame(
  USUBJID = factor(rep(c("S1", "S2", "S3"), each = 3)),
  AVISIT = factor(rep(c("Week 4", "Week 8", "Week 12"), 3),
                  levels = c("Week 4", "Week 8", "Week 12")),
  TRT = factor(rep(c("Placebo", "Drug A", "Drug A"), each = 3)),
  CHG = rnorm(9),
  DISCFL = c("N","N","N", "N","Y","Y", "N","N","Y")
)

vars <- set_vars(
  subjid = "USUBJID",
  visit = "AVISIT",
  group = "TRT",
  outcome = "CHG"
)

ice <- prepare_data_ice(dat, vars, ice_col = "DISCFL", strategy = "JR")
print(ice)

}
\seealso{
\itemize{
\item \code{\link[rbmi:draws]{rbmi::draws()}} which accepts the \code{data_ice} output from this function
\item \code{\link[=validate_data]{validate_data()}} to check data before imputation
\item \code{\link[=summarise_missingness]{summarise_missingness()}} to understand missing data patterns
}
}
