% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb.R
\name{rba_string_enrichment_image}
\alias{rba_string_enrichment_image}
\title{Get STRING Enrichment Plot}
\usage{
rba_string_enrichment_image(
  ids,
  species,
  category = "Process",
  image_format = "image",
  save_image = TRUE,
  group_by_similarity = NULL,
  color_palette = "mint_blue",
  number_of_term_shown = 10,
  x_axis = "signal",
  ...
)
}
\arguments{
\item{ids}{Your protein ID(s). It is strongly recommended to supply
STRING IDs. See \code{\link{rba_string_map_ids}} for more information.
Note that if only one id is supplied, STRING expands the network by 10
proteins.}

\item{species}{Numeric: NCBI Taxonomy identifier; Human Taxonomy ID is 9606.}

\item{category}{The terms set to use to perform enrichment analysis. valid
values are (See details for more info):
"Process" (default), "Function", "Component", "Keyword", "KEGG", "RCTM",
"HPO", "MPO", "DPO", "WPO", "ZPO", "FYPO", "Pfam", "SMART", "InterPro",
"PMID", "NetworkNeighborAL", "COMPARTMENTS", "TISSUES", "DISEASES", or
"WikiPathways"}

\item{image_format}{one of:\itemize{
\item "image": PNG image with normal resolution.
\item "highres_image": High-resolution PNG image.
\item "svg": Scalable Vector Graphics image.}}

\item{save_image}{Logical or Character:\itemize{
\item TRUE: Save the image to an automatically-generated path.
\item FALSE: Do not save the image, just return it as an R object.
\item Character string: A valid file path to save the image to.}}

\item{group_by_similarity}{Jackard index treshold to visually group the
related terms. Valid values are between 0.1 to 1 with increment of 0.1.
Default value is NULL (i.e. no grouping).}

\item{color_palette}{Color pallet to code FDR values. Valid values are:
"mint_blue" (default), "lime_emerald", "green_blue", "peach_purple",
"straw_navy", or "yellow_pink"}

\item{number_of_term_shown}{(default: 10) Maximum number of results to
include in the plot.}

\item{x_axis}{The variable to show on the x axis and rank the results based
on it. Valid values are: "signal" (default), "strength", "FDR", or
"gene_count"}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A plot summarizing the enrichment results, which can be PNG or
  SVG depending on the inputs.
}
\description{
In addition to performing enrichment analysis, STRING allows you to also
  visualize the analysis results. Use \code{\link{rba_string_enrichment}}
  to retrieve the analysis results as a data frame.
}
\details{
Available values for category are as follow. Default value is "Process".
  \itemize{
  \item Process: Biological Process (Gene Ontology)
  \item Function: Molecular Function (Gene Ontology)
  \item Component: Cellular Component (Gene Ontology)
  \item Keyword: Annotated Keywords (UniProt)
  \item KEGG: KEGG Pathways
  \item RCTM: Reactome Pathways
  \item HPO: Human Phenotype (Monarch)
  \item MPO: The Mammalian Phenotype Ontology (Monarch)
  \item DPO: Drosophila Phenotype (Monarch)
  \item WPO: C. elegans Phenotype Ontology (Monarch)
  \item ZPO: Zebrafish Phenotype Ontology (Monarch)
  \item FYPO: Fission Yeast Phenotype Ontology (Monarch)
  \item Pfam: Protein Domains (Pfam)
  \item SMART: Protein Domains (SMART)
  \item InterPro: Protein Domains and Features (InterPro)
  \item PMID: Reference Publications (PubMed)
  \item NetworkNeighborAL: Local Network Cluster (STRING)
  \item COMPARTMENTS: Subcellular Localization (COMPARTMENTS)
  \item TISSUES: Tissue Expression (TISSUES)
  \item DISEASES: Disease-gene Associations (DISEASES)
  \item WikiPathways: WikiPathways}
}
\section{Corresponding API Resources}{

 "POST https://string-db.org/api/\{output_format\}/enrichmentfigure"
}

\examples{
\dontrun{
  rba_string_enrichment_image(
  ids = c("TP53", "TNF", "EGFR"),
  species = 9606,
  category = "KEGG"
  )
}
\dontrun{
  rba_string_enrichment_image(
  ids = c("TP53", "TNF", "EGFR"),
  species = 9606,
  x_axis = "strength",
  number_of_term_shown = 20
  )
}
\dontrun{
  rba_string_enrichment_image(
  ids = c("TP53", "TNF", "EGFR"),
  species = 9606,
  color_palette = "straw_navy"
  )
}

}
\references{
\itemize{
  \item Damian Szklarczyk, Rebecca Kirsch, Mikaela Koutrouli, Katerina
   Nastou, Farrokh Mehryary, Radja Hachilif, Annika L Gable, Tao Fang,
   Nadezhda T Doncheva, Sampo Pyysalo, Peer Bork, Lars J Jensen, Christian
   von Mering, The STRING database in 2023: protein–protein association
   networks and functional enrichment analyses for any sequenced genome of
   interest, Nucleic Acids Research, Volume 51, Issue D1, 6 January 2023,
   Pages D638–D646, https://doi.org/10.1093/nar/gkac1000
  \item \href{https://string-db.org/help/api/}{STRING API Documentation}
  \item
  \href{https://string-db.org/cgi/about?footer_active_subpage=references}{
  Citations note on STRING website}
  }
}
\seealso{
\code{\link{rba_string_map_ids},
  \link{rba_string_enrichment},
  \link{rba_string_annotations}
  }

Other "STRING": 
\code{\link{rba_string_annotations}()},
\code{\link{rba_string_enrichment}()},
\code{\link{rba_string_enrichment_ppi}()},
\code{\link{rba_string_homology_inter}()},
\code{\link{rba_string_homology_intra}()},
\code{\link{rba_string_interaction_partners}()},
\code{\link{rba_string_interactions_network}()},
\code{\link{rba_string_map_ids}()},
\code{\link{rba_string_network_image}()},
\code{\link{rba_string_version}()}

Other "Enrichment/Over-representation": 
\code{\link{rba_enrichr}()},
\code{\link{rba_mieaa_enrich}()},
\code{\link{rba_panther_enrich}()},
\code{\link{rba_reactome_analysis}()},
\code{\link{rba_string_enrichment}()}
}
\concept{"Enrichment/Over-representation"}
\concept{"STRING"}
