% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbc.R
\name{rbc}
\alias{rbc}
\title{Fit a regression by composition model}
\usage{
rbc(formula, init, flows, family, data, par, hessian = TRUE)
}
\arguments{
\item{formula}{a formula object, with model components separated by '|'}

\item{init}{the initial distribution}

\item{flows}{a list of flows}

\item{family}{(optional) an object of class 'CompositeFamily';
if supplied, 'init' and 'flows' are ignored}

\item{data}{a data frame}

\item{par}{a vector of starting values}

\item{hessian}{logical; use Hessian matrix in model fitting?}
}
\value{
an rbc object
}
\description{
Fit a regression by composition model
}
\examples{
## Annette Dobson (1990)
## "An Introduction to Generalized Linear Models".
## Page 9: Plant Weight Data.
ctl <- c(4.17, 5.58, 5.18, 6.11, 4.50, 4.61, 5.17, 4.53, 5.33, 5.14)
trt <- c(4.81, 4.17, 4.41, 3.59, 5.87, 3.83, 6.03, 4.89, 4.32, 4.69)
dobson <- data.frame(
  weight = c(ctl, trt),
  group = gl(2, 10, 20, labels = c("Ctl", "Trt"))
)
dobson_fit <- rbc(weight ~ 1 | 1 + group,
  init = Normal(0, 1),
  flows = list(Scale, Translate),
  data = dobson
)

starr_fit <- rbc(
  height ~ 1 | 0 + I((280 + age)^(-1)) | 1 | 1,
  init = LogNormal(),
  flows = list(Power, Moebius, Scale, Translate),
  data = subset(starr, id \%in\% unique(id)[1:10])
)
}
