% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srt_method.r
\name{srt_method}
\alias{srt_method}
\title{Methods selector for the signed-rank test.}
\usage{
srt_method(x, test_class = "auto")
}
\arguments{
\item{x}{(named list)\cr
The object returned by \code{\link[=srt_ranks]{srt_ranks()}}.}

\item{test_class}{(Scalar character)\cr
This argument should only be used inside \code{.zd()} (asymptotic test inversion for CI), for speed, and should be left to the default value in an 'srt pipeline'.
Must be one of \code{"auto"}, \code{"wilcoxon"}, \code{"shift"}, or \code{"asymptotic"}.
If \code{"auto"} (default), the test class class will automatically be chosen based on properties of the data and \code{x$call$distribution}.
Otherwise, the function will return early with class set to \code{test_class}.}
}
\value{
list
}
\description{
Performs four tasks:
\enumerate{
\item Selects the appropriate methods for a signed-rank test.
\item Selects the appropriate methods for a confidence interval.
\item Checks for invalid data before continuing with calculating test results.
\item Calculates the number of tied values among the ranked absolute differences.
}
}
\details{
The signed-rank method is chosen by:

\itemize{
\item If ties are absent and zeros are absent, the exact null distribution of \eqn{W^+} depends only on \eqn{n_{\text{signed}} = |\mathcal{I}_{\neq 0}|} and can be obtained from \code{\link[stats:SignRank]{stats::psignrank()}} or \code{\link[stats:SignRank]{stats::qsignrank()}}.
\item If ties are present or when zeros are present, the exact null distribution is the distribution of a random subset-sum of the \code{ranks} weights.
Methods such as \code{\link[exactRankTests:dperm]{exactRankTests::pperm()}} or \code{\link[exactRankTests:dperm]{exactRankTests::qperm()}} are appropriate.
\item For normal approximations, the mean and variance of \eqn{W^+} under the symmetry null are \eqn{\mathrm{E}(W^+) = \tfrac{1}{2}\sum r_i} and \eqn{\mathrm{Var}(W^+) = \tfrac{1}{4}\sum r_i^2} computed over \code{ranks}.
}

The \code{srt} pipeline uses two intermediate classes for internal routing of calculations.
\enumerate{
\item The test class (\code{"wilcoxon"}, \code{"shift"}, or \code{"asymptotic"}) is determined by properties of the data and \code{x$call$distribution}.
\item The confidence interval class (\code{"inversion"}, \code{"bootstrap"}, \code{"none"}) is determined by \code{x$call$conf_level} and \code{x$call$conf_method}.
The final user facing result class is either \code{srt} or \code{rdt}, determined by the calling function.
}
}
\keyword{internal}
