% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{fill}
\alias{fill}
\alias{falses}
\alias{trues}
\alias{ones}
\alias{zeros}
\title{Fill a Matrix}
\usage{
fill(x, nrow = 1, ncol = 1, ..., atleast_2d = NULL)

falses(nrow = 1, ncol = 1, ..., atleast_2d = NULL)

trues(nrow = 1, ncol = 1, ..., atleast_2d = NULL)

ones(nrow = 1, ncol = 1, ..., atleast_2d = NULL)

zeros(nrow = 1, ncol = 1, ..., atleast_2d = NULL)
}
\arguments{
\item{x}{The (single) value to fill the \link{matrix} with.}

\item{nrow}{The desired number of rows.}

\item{ncol}{The desired number of columns.}

\item{...}{Further dimensions of the array.}

\item{atleast_2d}{Logical indicating whether or not to force column vectors
to have a second dimension equal to one. Defaults to \code{FALSE}. This
behavior can also be changed globally using, for example
\code{options(atleast_2d = TRUE)}.}
}
\value{
A \link{matrix} or \link{array} filled with the value \code{x}.
}
\description{
Create a matrix filled with the value \code{x}.
}
\examples{
fill(pi, 3, 5) # 3-by-5 matrix filled with the value of pi
fill(pi, 3, 5, 2, 2) # 3-by-5-by-2-by-2 array filled with the value of pi
pi * ones(3, 5)
zeros(10)
zeros(10, atleast_2d = TRUE)
}
\seealso{
\link{ones}, \link{zeros}, \link{falses}, \link{trues}, \link{mat}, and \link{matrix}
}
