% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orders.R
\name{td_orderSearch}
\alias{td_orderSearch}
\title{Search for orders by date}
\usage{
td_orderSearch(
  accountNumber,
  startDate = Sys.Date() - 30,
  endDate = Sys.Date(),
  maxResults = 50,
  orderStatus = "",
  accessToken = NULL
)
}
\arguments{
\item{accountNumber}{The TD brokerage account number associated with the
Access Token}

\item{startDate}{Orders from a certain date with. Format yyyy-mm-dd. TD
indicates there is a 60 day max, but this limit may not always apply}

\item{endDate}{Filter orders that occurred before a certain date. Format
yyyy-mm-dd}

\item{maxResults}{the max results to return in the query}

\item{orderStatus}{search by order status (ACCEPTED, FILLED, EXPIRED,
CANCELED, REJECTED, etc)}

\item{accessToken}{A valid Access Token must be set using
\code{\link{td_auth_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
a list of three objects: a jsonlite formatted extract of all orders,
  all entered orders with details, a data frame of all executed orders with
  the executions
}
\description{
Search for orders associated with a TD account over the previous 60 days. The
result is a list of three objects: 
\enumerate{ 
\item jsonlite formatted extract of all orders 
\item all entered orders with details 
\item a data frame of all executed orders with the executions }
}
\examples{
\dontrun{

# Get all orders run over the last 50 days (up to 500)
td_orderSearch(accountNumber = 987654321, 
             startDate = Sys.Date()-days(50),
             maxResult = 500, orderStatus = 'FILLED')

}
}
