% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdown-document.R
\name{MarkdownDocumentChunks}
\alias{MarkdownDocumentChunks}
\title{Markdown documents chunks}
\arguments{
\item{chunks}{A data frame containing \code{start}, \code{end}, and \code{context} columns,
and optionally other columns.}

\item{document}{A \code{MarkdownDocument}.}
}
\value{
An S7 object that inherits from \code{MarkdownDocumentChunks}, which is
also a \code{tibble}.
}
\description{
\code{MarkdownDocumentChunks} stores information about candidate chunks in a
Markdown document. It is a tibble with three required columns:
\itemize{
\item \code{start}, \code{end} — integers. These are character positions (1-based, inclusive) in the source
\code{MarkdownDocument}, so that \code{substring(md, start, end)} yields the chunk
text. Ranges can overlap.
\item \code{context} — character.
A general-purpose field for adding context to a chunk. This column is
combined with \code{text} to augment chunk content when generating embeddings with
\code{ragnar_store_insert()}, and is also returned by \code{ragnar_retrieve()}. Keep in
mind that when chunks are deoverlapped (in \code{ragnar_retrieve()} or
\code{chunks_deoverlap()}), only the context value from the first chunk is kept.
\code{markdown_chunk()} by default populates this column with all the markdown
headings that are in-scope at the chunk start position.
}

Additional columns can be included.

The original document is available via the \verb{@document} property.

For normal use, chunk a Markdown document with \code{\link[=markdown_chunk]{markdown_chunk()}}; the
class constructor itself is exported only so advanced users can generate or
tweak chunks by other means.
}
\examples{
doc_text <- "# A\n\nB\n\n## C\n\nD" # can be readLines() output, etc.
doc <- MarkdownDocument(doc_text, origin = "some/where")
chunk_positions <- tibble::tibble(
  start = c(1L, 9L),
  end = c(8L, 15L),
  context = c("", "# A"),
  text = substring(doc, start, end)
)
chunks <- MarkdownDocumentChunks(chunk_positions, doc)
identical(chunks@document, doc)
}
\seealso{
\code{\link[=MarkdownDocument]{MarkdownDocument()}}
}
