% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RN_bin_screen_phot.R
\name{RN_bin_screen_phot}
\alias{RN_bin_screen_phot}
\title{Search for radioisotopes that dominate a specified energy bin}
\usage{
RN_bin_screen_phot(
  E_min = 0,
  E_max = 10,
  min_prob = 0,
  min_half_life_seconds = NULL,
  max_half_life_seconds = NULL,
  no_E_min = 0,
  no_E_max = 10,
  no_min_prob = 100,
  no_E_min2 = 0,
  no_E_max2 = 10,
  no_min_prob2 = 100
)
}
\arguments{
\item{E_min}{target energy range minimum in MeV, default = 0}

\item{E_max}{target energy range maximum in MeV, default = 10}

\item{min_prob}{minimum probability of selected range with default = 0.}

\item{min_half_life_seconds}{minimum half-life in seconds.
Use multiplier as needed, e.g. 3 * 3600 for 3 hours. Default = NULL,}

\item{max_half_life_seconds}{maximum half-life. See min_half_life_seconds.}

\item{no_E_min, no_E_min2}{minimum energies in ranges to minimize in MeV, default = 0}

\item{no_E_max, no_E_max2}{maximum energies in bins to minimize in MeV, default = 10}

\item{no_min_prob, no_min_prob2}{minimum probability to minimize with default = 100 (no minimum).}
}
\value{
radionuclides that match selection criteria
}
\description{
Identify photon emitters that represent a target range of energies, while screening
out other selected energy ranges. This may be helpful for identifying radionuclides
in low-definition spectroscopy or in selecting representative spectra for modeling
shielding.
}
\examples{
RN_bin_screen_phot(
  E_min = 0.1, E_max = 0.3,
  min_prob = 0.4, min_half_life_seconds = 30 * 24 * 3600,
  max_half_life_seconds = 3.153e7, no_E_min = 0.015,
  no_E_max = 0.0999, no_min_prob = 0.05, no_E_min2 = 0.301, no_E_max2 = 10, no_min_prob2 = 0.01
)
}
\seealso{
\code{\link[=RN_plot_spectrum]{RN_plot_spectrum()}}

Other radionuclides: 
\code{\link{RN_Spec_Act}()},
\code{\link{RN_index_screen}()},
\code{\link{RN_info}()},
\code{\link{RN_plot_df}()},
\code{\link{RN_plot_search_results}()},
\code{\link{RN_plot_spectrum}()},
\code{\link{RN_save_spectrum}()},
\code{\link{RN_search_alpha_by_E}()},
\code{\link{RN_search_beta_by_E}()},
\code{\link{RN_search_phot_by_E}()}
}
\concept{radionuclides}
