% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spain_1982.R
\name{spain_1982}
\alias{spain_1982}
\title{Spain model for fitting thermal performance curves}
\usage{
spain_1982(temp, a, b, c, r0)
}
\arguments{
\item{temp}{temperature in degrees centigrade}

\item{a}{constant that determines the steepness of the rising portion of the curve}

\item{b}{constant that determines the position of topt}

\item{c}{constant that determines the steepness of the decreasing part of the curve}

\item{r0}{the apparent rate at 0 ºC}
}
\value{
a numeric vector of rate values based on the temperatures and parameter values provided to the function
}
\description{
Spain model for fitting thermal performance curves
}
\details{
Equation:
\deqn{rate = r_0 \cdot exp^{a \cdot temp} \cdot (1-b \cdot exp^{c \cdot temp})}{%
rate = est = r0 . exp(a.temp) . (1 - b.exp(c.temp))}

Start values in \code{get_start_vals} are derived from the data or plucked from thin air.

Limits in \code{get_lower_lims} and \code{get_upper_lims} are derived from the data or plucked from thin air.
}
\note{
Generally we found this model easy to fit.
}
\examples{
# load in ggplot
library(ggplot2)

# subset for the first TPC curve
data('chlorella_tpc')
d <- subset(chlorella_tpc, curve_id == 1)

# get start values and fit model
start_vals <- get_start_vals(d$temp, d$rate, model_name = 'spain_1982')
# fit model
mod <- nls.multstart::nls_multstart(rate~spain_1982(temp = temp, a, b, c, r0),
data = d,
iter = c(3,3,3,3),
start_lower = start_vals - 1,
start_upper = start_vals + 1,
lower = get_lower_lims(d$temp, d$rate, model_name = 'spain_1982'),
upper = get_upper_lims(d$temp, d$rate, model_name = 'spain_1982'),
supp_errors = 'Y',
convergence_count = FALSE)

# look at model fit
summary(mod)

# get predictions
preds <- data.frame(temp = seq(min(d$temp), max(d$temp), length.out = 100))
preds <- broom::augment(mod, newdata = preds)

# plot
ggplot(preds) +
geom_point(aes(temp, rate), d) +
geom_line(aes(temp, .fitted), col = 'blue') +
theme_bw()

}
\references{
BASIC Microcomputer Models in Biology. Addison-Wesley, Reading, MA. 1982
}
