% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPBK.R
\name{fitPBK}
\alias{fitPBK}
\alias{fitPBK.stanPBKdata}
\title{Bayesian inference of TK model with Stan}
\usage{
fitPBK(stanPBKdata, ...)

\method{fitPBK}{stanPBKdata}(stanPBKdata, ...)
}
\arguments{
\item{stanPBKdata}{List of Data require for computing}

\item{\dots}{Arguments passed to \code{rstan::sampling} (e.g. iter, chains).}
}
\value{
An object of class \code{fitPBK} containing two object: \code{stanPBKdata}
the data set used for inference and \code{stanfit}  returned by \code{rstan::sampling}
}
\description{
Bayesian inference of TK model with Stan
}
\examples{
# (1) load data file
data("dataCompartment4")
# (2) prepare data set
dataPBK_C4 <- dataPBK(
  object = dataCompartment4,
  col_time = "temps",
  col_replicate = "replicat",
  col_exposure = "condition",
  col_compartment = c("intestin", "reste", "caecum", "cephalon"),
  time_accumulation = 7)
# (3) run Bayesian fitting: <5 sec to be executed
# 1 chain and 10 iterations is fast to run but provide
# bad goodness-of-fit
fitPBK_C4_FASTbadGOF <- fitPBK(dataPBK_C4, chains = 1, iter = 10)
\donttest{
  # (3) run Bayesian fitting: > 5 sec to be executed
  # 4 chains and 2000 iterations provides better estimates
  fitPBK_C4 <- fitPBK(dataPBK_C4, chains = 4, iter = 2000)
}

}
