% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapperFunctions.R
\name{analyzeFile}
\alias{analyzeFile}
\title{Analysis of a single corneal topography file}
\usage{
analyzeFile(path, drawplot = TRUE)
}
\arguments{
\item{path}{A corneal topography file, as exported by a Placido disk corneal topographer.}

\item{drawplot}{An optional parameter indicating whether a plot of results should be displayed or not (by default, \code{TRUE}).}
}
\value{
A \code{data.frame} containing the Placido irregularity indices as well as the diagnose, with a single row and columns:
\tabular{lll}{
  \code{Diagnose}   \tab\tab A text label indicating the diagnose, according to the value of GLPI\cr
  \code{NBI}   \tab\tab The value of NBI index (in the range 0-100).\cr
  \code{GLPI}  \tab\tab The value of GLPI index (in the range 0-100).\cr
  \code{PI_1}  \tab\tab The value of PI_1 index (usually in the range 0-150).\cr   
  \code{PI_2}  \tab\tab The value of PI_2 index (usually in the range 0-150).\cr   
  \code{PI_3}  \tab\tab The value of PI_3 index (usually in the range 0-150).\cr   
  \code{SL}  \tab\tab The value of SL index (usually in the range 0-150).\cr   
  \code{AR_1}  \tab\tab The value of AR_1 index (usually in the range 0-150).\cr
  \code{AR_2}  \tab\tab The value of AR_2 index (usually in the range 0-150).\cr   
  \code{AR_3}  \tab\tab The value of AR_3 index (usually in the range 0-150).\cr   
  \code{AR_4}  \tab\tab The value of AR_4 index (usually in the range 0-150).\cr   
  \code{AR_5}  \tab\tab The value of AR_5 index (usually in the range 0-150).\cr      
}
}
\description{
Analyze a corneal topography file. This function combines together the three operations performed
by the functions \link[rPACI]{readFile}, \link[rPACI]{computePlacidoIndices},
and \link[rPACI]{plotSingleCornea}.
The result is a \code{data.frame} in the same format given by \link[rPACI]{computePlacidoIndices}.
 
More details about supported file formats can be found in 
\href{../doc/topographersDataFormat.html}{\code{vignette("topographersDataFormat", package = "rPACI")}}, 
and about using \code{rPACI} in \href{../doc/packageUsage.html}{\code{vignette("packageUsage", package = "rPACI")}}.
}
\examples{
# Read the file, compute the indices and show results in one step with:
results = analyzeFile(system.file("extdata","N01.txt", package="rPACI"))

# The previous command is equivalent to:
dataset = readFile(system.file("extdata","N01.txt", package="rPACI"))
results = computePlacidoIndices(dataset)
# If drawplot=TRUE, then it also performs:
plotSingleCornea(dataset, results)
}
